IF EXISTS ( SELECT * FROM SYS.OBJECTS WHERE TYPE = 'TR' 
              AND name = 'Tri_Contratos_Hist_Upd')
BEGIN
    DROP TRIGGER dbo.Tri_Contratos_Hist_Upd 
END
GO

CREATE TRIGGER CT_Contratos_Hist_Upd 
ON Contratos
AFTER UPDATE
AS 

SET NOCOUNT ON
DECLARE @Id_Cliente					INT
DECLARE @Id_Tarjeta					VARCHAR(10)
DECLARE @Tar_Nro					VARCHAR(25)
DECLARE @Id_Contrato				INT
DECLARE @Item						SMALLINT
DECLARE @Id_Tarjeta_Ant				VARCHAR(10)
DECLARE @Tar_Nro_Ant				VARCHAR(25)
DECLARE @Item_Ant					SMALLINT


DECLARE Cur_Contratos_Hist_Upd 
CURSOR FOR
SELECT I.Id_Contrato, ISNULL(I.Id_Cliente, 0),	ISNULL(I.Id_Tarjeta, ''), ISNULL(I.Tar_Nro , '')
FROM Inserted I LEFT OUTER JOIN Deleted D ON I.Id_Contrato = D.Id_Contrato
WHERE
I.Id_Cliente <> ISNULL(D.Id_Cliente, 0)		OR		--Cambio el Cliente
(I.Id_Tarjeta  <> ISNULL(D.Id_Tarjeta, '')) OR		--Cambio Tipo Tarjeta
(I.Tar_Nro <> ISNULL(D.Tar_Nro, ''))				--Cambio Nro Tarjeta


OPEN Cur_Contratos_Hist_Upd
FETCH NEXT FROM Cur_Contratos_Hist_Upd INTO @Id_Contrato, @Id_Cliente, @Id_Tarjeta, @Tar_Nro
WHILE (@@FETCH_STATUS = 0)
BEGIN
	/*Busco si en CLIENTES_Hist habia un registro para ese contrato*/
	SET @Item_Ant	= ISNULL((SELECT MAX(ISNULL(Item, 0)) FROM Clientes_Hist WHERE Id_Cliente = @Id_Cliente AND Id_Contrato = @Id_Contrato), 0)
	/*Proximo Nro Item a insertar (Sin Id_contrato)*/
	SET @Item		= ISNULL((SELECT MAX(ISNULL(Item, 0)) FROM Clientes_Hist WHERE Id_Cliente = @Id_Cliente), 0) + 1

	IF (@Item_Ant = 0)
	BEGIN
		/*No tiene un registro previo para ese contrato, tiene que insertar el primero*/
		INSERT INTO Clientes_Hist 
		(Id_Cliente,		Item,			Fecha,
		Id_Tipo_Cli,		Id_Cobrador,	Fecha_Alta,
		Id_Motivo_Est,		Fecha_Baja,		Id_Usuario,
		Id_Cliente_Externo,	Id_Tarjeta,		Tar_Nro,
		Tar_Fecha_Alta,		Tar_Fecha_Baja,	Id_Cliente_Ref,
		Id_Contrato)
		SELECT 
		@Id_Cliente,		@Item,			GETDATE(),
		Id_Tipo_Cli,		Id_Cobrador,	Fecha_Alta,
		Id_Motivo_Est,		Fecha_Baja,		0,
		Id_Cliente_Externo,	@Id_Tarjeta,	@Tar_Nro,			--Le graba la tarjeta del contrato
		GETDATE(),			NULL,			Id_Cliente_Ref,
		@Id_Contrato											--Y el contrato
		FROM Clientes	
		WHERE 
		Id_Cliente = @Id_Cliente
	END
	ELSE
	BEGIN
		/*Busco los datos del contrato del ultimo item*/		
		SELECT
		@Id_Tarjeta_Ant = ISNULL(Id_Tarjeta, ''), 
		@Tar_Nro_Ant	= ISNULL(Tar_Nro, '')
		FROM Clientes_Hist 
		WHERE  
		Id_Cliente	= @Id_Cliente
		AND Item	= @Item_Ant
		
		IF ((@Id_Tarjeta <> @Id_Tarjeta_Ant) OR (@Tar_Nro <> @Tar_Nro_Ant))
		BEGIN
			/*Las tarjetas son disintas al registro anterior, por lo ranto se graban como un registro nuevo en el historial*/
			INSERT INTO Clientes_Hist 
			(Id_Cliente,		Item,			Fecha,
			Id_Tipo_Cli,		Id_Cobrador,	Fecha_Alta,
			Id_Motivo_Est,		Fecha_Baja,		Id_Usuario,
			Id_Cliente_Externo,	Id_Tarjeta,		Tar_Nro,
			Tar_Fecha_Alta,		Tar_Fecha_Baja,	Id_Cliente_Ref,
			Id_Contrato)
			SELECT 
			@Id_Cliente,		@Item,			GETDATE(),
			Id_Tipo_Cli,		Id_Cobrador,	Fecha_Alta,
			Id_Motivo_Est,		Fecha_Baja,		0,
			Id_Cliente_Externo,	@Id_Tarjeta,	@Tar_Nro,			--Le graba la tarjeta del contrato
			GETDATE(),			NULL,			Id_Cliente_Ref,
			@Id_Contrato											--Y el contrato
			FROM Clientes	
			WHERE 
			Id_Cliente = @Id_Cliente
			
			/*El registro anterior le actualiza Tar_Fecha_Baja para mantener un registro*/
			UPDATE Clientes_Hist 
			SET 
			Tar_Fecha_Baja = GETDATE() 
			WHERE 
			Id_Cliente = @Id_Cliente 
			AND Item = @Item_Ant

		END
	END
	
	FETCH NEXT FROM Cur_Contratos_Hist_Upd INTO @Id_Contrato, @Id_Cliente, @Id_Tarjeta, @Tar_Nro
END
CLOSE Cur_Contratos_Hist_Upd
DEALLOCATE Cur_Contratos_Hist_Upd